Unit PPI;

Interface

Procedure OutA(S, Adat : Byte);
{ S = 1 -> PPI1 kimenet A port
  S = 2 -> PPI2 kimenet A port
  (Ekkor a portot kimenetknt kell felprogramozni)}

Procedure OutB(S, Adat : Byte);
{ S = 1 -> PPI1 kimenet B port
  S = 2 -> PPI2 kimenet B port }

Procedure OutC(S, Adat : Byte);
{ S = 1 -> PPI1 kimenet C port
  S = 2 -> PPI2 kimenet C port }

Procedure Command(S, Adat : Byte);
{ S = 1 -> PPI1 parancsregiszter rsa
  S = 2 -> PPI2 parancsregiszter rsa }

Function InpA(S : Byte) : Byte;
{ S = 1 -> PPI1 A port beolvassa
  S = 2 -> PPI2 A port beolvassa
  (Ekkor a portot bemenetknt kell felprogramozni)}

Function InpB(S : Byte) : Byte;
{ S = 1 -> PPI1 B port beolvassa
  S = 2 -> PPI2 B port beolvassa
  (Ekkor a portot bemenetknt kell felprogramozni)}

Function InpC(S : Byte) : Byte;
{ S = 1 -> PPI1 C port beolvassa
  S = 2 -> PPI2 C port beolvassa
  (Ekkor a portot bemenetknt kell felprogramozni)}

Procedure SetC(S, Bit : Byte; HL : boolean);
{ S : PPI kivlaszts 1 vagy 2
  Bit : annak a bitnek a szma [0..7] amit lltani kell
  HL : True -> a bitet 1-be kell lltani
       False -> a bitet 0-ba kell lltani.}

Procedure SetPortBit(S : Byte; Szint, Portnev: Char; Bitszam:Byte);
{ S : PPI kivlaszts 1 vagy 2.
  Szint : 'L' vagy 'H' (lehet kisbet is) a belltand szint
  Portnev : 'A', 'B', 'C' (lehet kisbet is) a belltand port
  Bitszam : [0..7] a belltand bit szma.
  Csak kimenetre programozott PPI esetn! [ Command(S,128) ] }

Procedure Portteszt(S : Byte);
{ S : PPI kivlaszts 1 vagy 2.
  Kimen vonalakat lehet bitenknt tesztelni}

Implementation

Procedure OutA;
 Var cim : word;
 Begin
    Case s of
     1 : cim := $300;
     2 : cim := $308
     else Exit;
   End;
   Port[cim] := adat;
 End;

Procedure OutB;
 Var cim : word;
 Begin
   Case s of
     1 : cim := $301;
     2 : cim := $309
     else Exit;
   End;
   Port[cim] := adat;
 End;

Procedure OutC;
 Var cim : word;
 Begin
   Case s of
     1 : cim := $302;
     2 : cim := $30A
     else Exit;
   End;
   Port[cim] := adat;
 End;

Procedure Command;
 Var cim : word;
 Begin
   Case s of
     1 : cim := $303;
     2 : cim := $30B
     else Exit;
   End;
   Port[cim] := adat;
 End;

Function InpA;
 Var cim : word;
 Begin
    Case s of
     1 : cim := $300;
     2 : cim := $308
     else Exit;
   End;
   inpa := Port[cim];
 End;

Function InpB;
 Var cim : word;
 Begin
    Case s of
     1 : cim := $301;
     2 : cim := $309
     else Exit;
   End;
   inpb := Port[cim];
 End;

Function InpC;
 Var cim : word;
 Begin
    Case s of
     1 : cim := $302;
     2 : cim := $30A
     else Exit;
   End;
   inpc := Port[cim];
 End;

Procedure SetC;
 Var a : Byte;
   cim : word;
 Begin
    Case s of
     1 : cim := $302;
     2 : cim := $30A
     else Exit;
   End;
   a := 2 * bit;
   if HL then inc(a);
   Command(s,a);
 End;

Procedure SetPortBit;
    Procedure PortBitH(cc : char; bit : Byte);
        function bitertek(bb : Byte) : Byte;
          const t : array[0..7] of Byte = (1,2,4,8,16,32,64,128);
          begin
            bitertek := t[bb];
          end;
        var bitbe : Byte;
      begin
       case Upcase(cc) of
         'A' : begin
                 bitbe := InpA(s) or BitErtek(bit);
                 OutA(s,bitbe);
               end;
         'B' : begin
                 bitbe := InpB(s) or BitErtek(bit);
                 OutB(s,bitbe);
               end;
         'C' : begin
                 bitbe := InpC(s) or BitErtek(bit);
                 OutC(s,bitbe);
               end;
       end;
     End;
     Procedure PortBitL(cc : char; bit : Byte);
        function bitertek(bb : Byte) : Byte;
          const t : array[0..7] of Byte = (254,253,251,247,239,223,191,127);
          begin
            bitertek := t[bb];
          end;
       var bitbe : Byte;
     begin
       case Upcase(cc) of
         'A' : begin
                 bitbe := InpA(s) and BitErtek(bit);
                 OutA(s,bitbe);
               end;
         'B' : begin
                 bitbe := InpB(s) and BitErtek(bit);
                 OutB(s,bitbe);
               end;
         'C' : begin
                 bitbe := InpC(s) and BitErtek(bit);
                 OutC(s,bitbe);
               end;
       end;
     End;

 begin
  szint := Upcase(szint);
  portnev := Upcase(portnev);
  if (bitszam > 7) or
     ((portnev <>'A') and (portnev <>'B') and (portnev <>'C')) or
     ((szint <> 'H') and (szint <> 'L')) then Exit;
  if szint = 'L' then PortBitL(portnev,bitszam)
                 else PortBitH(portnev,bitszam);
 End;

Procedure Portteszt;
var p1,p3 : char;
    p2 : Byte;
begin
repeat
  Write('Melyik port ? (A,B,C) ');
  readln(p1);
  Write('Melyik bit ? (0..7) ');
  readln(p2);
  Write('L vagy H ? ');
  readln(p3);
  p3 := Upcase(p3);
  SetPortBit(s,p3,p1,p2);
until (p3<>'L') and (p3 <>'H');
end;   {portteszt}


Begin
End.